-- Access the Lightroom SDK namespaces.
local LrTasks = import 'LrTasks'
local catalog = import "LrApplication".activeCatalog()
local ProgressScope = import 'LrProgressScope'
local LrFunctionContext = import 'LrFunctionContext'
local LrBinding = import 'LrBinding'
local LrDialogs = import 'LrDialogs'
local LrView = import 'LrView'
local bind = LrView.bind -- shortcut for bind() method
local LrHttp = import 'LrHttp'

local LrLogger = import 'LrLogger'
local myLogger = LrLogger( 'LightRoomLogger' )
myLogger:enable( "logfile" ) -- Pass either a string or a table of actions.
local function outputToLog( message )
    myLogger:trace( message )
end

function explode(d,p)
  local t, ll
  t={}
  ll=0
  if(#p == 1) then return {p} end
    while true do
      l=string.find(p,d,ll,true) -- find the next d in the string
      if l~=nil then -- if "not not" found then..
        table.insert(t, string.sub(p,ll,l-1)) -- Save it in our array.
        ll=l+1 -- save just after where we found it for searching next time.
      else
        table.insert(t, string.sub(p,ll)) -- Save what's left in our array.
        break -- Break at end, as it should be, according to the lua manual.
      end
    end
  return t
end

function checkConnection()
    local url = "http://printcompetition.com/verifyConnection.php"
    local checkResult = LrHttp.get(url);
    --outputToLog(checkResult)
    --LrDialogs.message(checkResult)
    if checkResult ~= 'goodconnection' then
      LrDialogs.message( "No Connection", "Connection to printcompetition.com failed.\nVerify your WiFi connection.", "info" );
      return false
    end
    return true
end
function checkConnection1(systm)
    local url = "http://"..systm.."/verifyConnection.php"
    local checkResult = LrHttp.get(url);
    --outputToLog(checkResult)
    if checkResult ~= 'goodconnection' then
      LrDialogs.message( "No Connection", "Connection to printcompetition.com failed.\nVerify your WiFi connection.", "info" );
      return false
    end
    return true
end


function applyKeyWord(indivphoto,keyword)
    if keyword ~= '--' then
        indivphoto:addKeyword(catalog:createKeyword( keyword, {}, true, nil, true ) )
    end
end
function removeRelevantKeyWord(indivphoto)
    local allkeywords = catalog:getKeywords()
    for key,keyword in pairs(allkeywords) do
        outputToLog(keyword:getName())
        if(keyword:getName()=='<78') then
            indivphoto:removeKeyword(keyword)
        end
        if(keyword:getName()=='7879') then
            indivphoto:removeKeyword(keyword)
        end
        if(keyword:getName()=='8081') then
            indivphoto:removeKeyword(keyword)
        end
        if(keyword:getName()=='>81') then
            indivphoto:removeKeyword(keyword)
        end
        if(keyword:getName()=='merit') then
            indivphoto:removeKeyword(keyword)
        end
    end
end



local function refreshDialog()

    LrFunctionContext.callWithContext( "refreshDialog", function( context )

        LrTasks.startAsyncTask( function()

            --if not connectionDialog() then return end
            --if not checkConnection() then return end

            local photos=catalog:getTargetPhotos()

            if #photos == 0 then
                LrDialogs.message( "Error", "You must select at least one image.", "info" );
                return
            end

            for j, photo in ipairs(photos) do
                varFile  = 	photo:getFormattedMetadata('fileName')
                varScore = 	photo:getFormattedMetadata('headline')
                --outputToLog(varFile .. ' ' .. varScore)
            end

            local f = LrView.osFactory()

            local props = {}
            local c = {}

            props.systm = ''
            props.score = varScore
            props.filename = varFile

            -- Create the contents for the dialog.
            local c = f:row {

                -- Bind the table to the view.  This enables controls to be bound
                -- to the named field of the 'props' table.

                bind_to_object = props,

                -- Add a checkbox and an edit_field.

                --f:checkbox {
                    --title = "Enable",
                    --value = LrView.bind( "isChecked" ),
                --},
                f:group_box {
                    title = "",
                    fill_horizontal = 1,
                    spacing = f:control_spacing(),
                    f:static_text {
                        fill_horizontal = 1,
                        title = "Select a Server\nIf you do not know select the first one.",
                    },
                    f:popup_menu {
                        value = bind 'systm',
                        items = {
                                    { title = "PrintCompetition.com", value = 'PrintCompetition.com' },
                                    { title = "Aruba", value = 'aruba.local' },
                                    { title = "Largo", value = 'largo.local' },
                                    { title = "Kitts", value = 'kitts.local' },
                                    { title = "Nevis", value = 'nevis.local' },
                                    { title = "Lucia", value = 'lucia.local' },
                        }
                    },
                },


            }

            local buttonpressed = LrDialogs.presentModalDialog {
                    title = "Select Server",
                    contents = c
                }

            if props.systm ~= '' then
                if buttonpressed == 'ok' then

                    if not checkConnection1(props.systm) then return end

                    LrTasks.startAsyncTask( function()

                        if not checkConnection() then return end

                        local photos=catalog:getTargetPhotos()
                        if #photos == 0 then return end
                        lrItem  = 1
                        varFileName = ""
                        varFileNames = {}
                        local ProgressScope = ProgressScope({title = "My progress bar title" ,caption = "My progress bar caption",})
                        for j, photo in ipairs(photos) do
                            varFile = 	photo:getFormattedMetadata('fileName')
                            grey = string.find(varFile,'greyimage');
                            if grey == nil then
                                local url = "http://"..props.systm.."/showLightroomData.php?filename=" .. varFile
                                varResult = LrHttp.get(url)
                                --outputToLog(varResult)


                                if  varResult ~= '' then

                                --outputToLog(varResult)

                                    local t = {}

                                    ----------
                                    -- parse results and load table (array) with key-value pairs
                                    ----------
                                    resultpairs= explode("|",varResult);
                                    for ii,resultpair in pairs(resultpairs) do
                                        resultdetail = explode("=",resultpair)
                                        local key =  resultdetail[1]
                                        local val =  resultdetail[2]
                                        if (val == '') then val = '--' end
                                        t[key] = val
                                    end

                                    --if(t['version']~='2.0') then LrDialogs.message( "Warning", "Wrong Script Version. Need " .. t['version'], "info" ) end;

                                    --outputToLog('>>>>>>>')
                                    --outputToLog(t['score'])
                                    --outputToLog('>>>>>>>')

                                    ----------
                                    -- loop the table of reults if you like
                                    ----------
                                    --for key,val in pairs(t) do
                                        --outputToLog(key)
                                    --end

                                    photo.catalog:withWriteAccessDo("try it",function()


                                        local rmvphotos={}
                                        currentcollections = photo:getContainedCollections()
                                        for key,coll in pairs(currentcollections) do
                                            if coll:getParent() then
                                                local parent = coll:getParent():getName()
                                                if parent =='merit' then
                                                    table.insert(rmvphotos,photo)
                                                    coll:removePhotos(rmvphotos)
                                                end
                                                if parent =='non merit' then
                                                    table.insert(rmvphotos,photo)
                                                    coll:removePhotos(rmvphotos)
                                                end
                                            end
                                        end


                                        local thisCollectionSet = catalog:createCollectionSet( t['collectionset'], nil, true )
                                        local thisCollection = catalog:createCollection( t['collection'], thisCollectionSet, true )
                                        local colphotos={}
                                        table.insert(colphotos,photo)
                                        thisCollection:addPhotos(colphotos)

                                        local allkeywords = catalog:getKeywords()
                                        for key,keyword in pairs(allkeywords) do
                                            photo:removeKeyword(keyword)
                                        end

                                        photo:setRawMetadata('rating','')

                                        photo:setRawMetadata('descriptionWriter','entry'..t['entrynumber'])
                                        photo:setRawMetadata('title',t['title'])

                                        photo:setRawMetadata('caption',t['cat'])

                                        --photo:setRawMetadata('iptcCategory',t['cat'])
                                        photo:setRawMetadata('copyright',t['score'])
                                        photo:setRawMetadata('headline',t['score'])
                                        photo:setRawMetadata('copyName',t['entrytype'])


                                        photo:setRawMetadata('creator',t['name'])
                                        photo:setRawMetadata('creatorAddress',t['address'])
                                        photo:setRawMetadata('creatorCity',t['city'])
                                        photo:setRawMetadata('creatorStateProvince',t['state'])
                                        photo:setRawMetadata('creatorPostalCode',t['zip'])
                                        photo:setRawMetadata('creatorPhone',t['cellphone'])
                                        photo:setRawMetadata('creatorEmail',t['email'])
                                        photo:setRawMetadata('creatorUrl',t['website'])
                                        photo:setRawMetadata('creatorCountry',t['country'])
                                        --photo:setRawMetadata('pickStatus',0)

                                        keywordpairs= explode("^",t['keywords']);
                                        for ii,keywrd in pairs(keywordpairs) do
                                            if (keywrd == '') then keywrd = '--' end
                                            --outputToLog(keywrd);
                                            applyKeyWord(photo,keywrd)
                                        end

                                        --applyKeyWord(photo,'jeff')
                                        --applyKeyWord(photo,t['entrytype'])
                                        --applyKeyWord(photo,t['cat'])
                                        --applyKeyWord(photo,t['fuji'])
                                        --applyKeyWord(photo,t['kodak'])
                                        --applyKeyWord(photo,t['lexjet'])
                                        --applyKeyWord(photo,t['polaroid'])
                                        --applyKeyWord(photo,t['localaward'])
                                        --applyKeyWord(photo,t['soleartist'])
                                        --applyKeyWord(photo,t['ppa'])
                                        --applyKeyWord(photo,t['asp'])
                                        --applyKeyWord(photo,t['cpp'])
                                        --applyKeyWord(photo,t['master'])
                                        --applyKeyWord(photo,t['firsttime'])
                                        --applyKeyWord(photo,t['memberstatus'])
                                        --applyKeyWord(photo,t['premium'])
                                        --applyKeyWord(photo,t['scoregroup'])
                                        --applyKeyWord(photo,t['merit'])
                                        --applyKeyWord(photo,t['cattype'])


                                        --photo:addKeyword(catalog:createKeyword( t['entrytype'], {}, true, nil, true ) )
                                        --photo:addKeyword(catalog:createKeyword( t['cat'], {}, true, nil, true ) )
                                        --photo:addKeyword(catalog:createKeyword( t['fuji'], {}, true, nil, true ) )
                                        --photo:addKeyword(catalog:createKeyword( t['kodak'], {}, true, nil, true ) )
                                        --photo:addKeyword(catalog:createKeyword( t['lexjet'], {}, true, nil, true ) )
                                        --photo:addKeyword(catalog:createKeyword( t['polaroid'], {}, true, nil, true ))
                                        --photo:addKeyword(catalog:createKeyword( t['localaward'], {}, true, nil, true ))
                                        --photo:addKeyword(catalog:createKeyword( t['soleartist'], {}, true, nil, true ) )
                                        --photo:addKeyword(catalog:createKeyword( t['ppa'], {}, true, nil, true ) )
                                        --photo:addKeyword(catalog:createKeyword( t['asp'], {}, true, nil, true ) )
                                        --photo:addKeyword(catalog:createKeyword( t['cpp'], {}, true, nil, true ) )
                                        --photo:addKeyword(catalog:createKeyword( t['master'], {}, true, nil, true ))
                                        --photo:addKeyword(catalog:createKeyword( t['firsttime'], {}, true, nil, true ) )
                                        --photo:addKeyword(catalog:createKeyword( t['memberstatus'], {}, true, nil, true ))
                                        --photo:addKeyword(catalog:createKeyword( t['premium'], {}, true, nil, true ) )
                                        --photo:addKeyword(catalog:createKeyword( t['scoregroup'], {}, true, nil, true ))
                                        --photo:addKeyword(catalog:createKeyword( t['merit'], {}, true, nil, true ) )
                                        --photo:addKeyword(catalog:createKeyword( t['cattype'], {}, true, nil, true ) )

                                    end)

                                end

                            end

                            lrItem = lrItem + 1

                            ProgressScope:setPortionComplete(lrItem/#photos)
                            ProgressScope:setCaption( lrItem .. "/" .. #photos .. '  ' .. photo:getFormattedMetadata('fileName'))

                        end

                        ProgressScope:done()
                        LrDialogs.message( "Update Complete", "All images have been updated.", "info" );

                    --outputToLog( "-----done----" )


                    end)

                else
                    --LrDialogs.message('wrong button')
                end
            else
                LrDialogs.message('you did not select a server')
            end

        end)

    end)

end



refreshDialog()


